package gov.va.vamf.scheduling.direct.validator;


import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.jsoup.safety.Cleaner;
import org.jsoup.safety.Whitelist;

import java.util.Iterator;

public class XSSValidator {
    public boolean hasXSSInjection(String input){
        if (new Cleaner( Whitelist.basic()).isValid( getFragmentAsDocument( input ))){
            return false;
        }
        return true;
    }

    protected Document getFragmentAsDocument(CharSequence value) {
        Document fragment = Jsoup.parse( value.toString(), "", Parser.xmlParser() );
        Document document = Document.createShell( "" );

        // add the fragment's nodes to the body of resulting document
        Iterator<Element> nodes = fragment.children().iterator();
        while ( nodes.hasNext() ) {
            document.body().appendChild( nodes.next() );
        }

        return document;
    }
}
